// PCW99_ODBC_Generic_OLTP_Read_Select.cpp

#include "stdafx.h"
#include "PCW99_ODBC_Generic.h"
#include "PCW99_ODBC_Generic_OLTP_Read_Select.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_01,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_02,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_03,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_04,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_05,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_06,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_07,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_08,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_09,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_10,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_11,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_12,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_13,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_14,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_15,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_16,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_17,CXact,1)
IMPLEMENT_SERIAL(CXact_OLTP_Read_Select_18,CXact,1)

// ================================================================================

// CXact_OLTP_Read_Select_01

CXact_OLTP_Read_Select_01::CXact_OLTP_Read_Select_01 (void)
{
	m_szName		= "OLTP Read Select 01";
	m_szDescription = "select p_key, p_code, p_date, p_signed, p_name from fourram where p_key = :randfourram";
	m_szSQL			= "select p_key, p_code, p_date, p_signed, p_name from fourram where p_key = ?";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+01;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_01::~CXact_OLTP_Read_Select_01 (void)
{
}

BOOL CXact_OLTP_Read_Select_01::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_01::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_01::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randfourram;
	struct OLTP_READ_SELECT_01 {
		SQLINTEGER p_key;
		SQLCHAR p_code[15];
		SQLCHAR p_date[35];
		SQLINTEGER p_signed;
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_SELECT_01 OLTP_READ_SELECT_01;
	struct OLTP_READ_SELECT_01_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_code;
		SQLINTEGER p_date;
		SQLINTEGER p_signed;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_SELECT_01_INDICATORS OLTP_READ_SELECT_01_INDICATORS;
	OLTP_READ_SELECT_01 oltp_read_select_01_array[NUM_ROWS];
	OLTP_READ_SELECT_01_INDICATORS oltp_read_select_01_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_01_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randfourram, sizeof(randfourram), &BindParamInd);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_01_array[0].p_key, sizeof(oltp_read_select_01_array[0].p_key), &oltp_read_select_01_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_select_01_array[0].p_code, sizeof(oltp_read_select_01_array[0].p_code), &oltp_read_select_01_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_select_01_array[0].p_date, sizeof(oltp_read_select_01_array[0].p_date), &oltp_read_select_01_indicators_array[0].p_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_select_01_array[0].p_signed, sizeof(oltp_read_select_01_array[0].p_signed), &oltp_read_select_01_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_01_array[0].p_name, sizeof(oltp_read_select_01_array[0].p_name), &oltp_read_select_01_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randfourram = (long) m_CRandom.GetRandom(2,RANDFOURRAM);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;
			
		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_01_array[iRowLoop].p_key << tab
					<< oltp_read_select_01_array[iRowLoop].p_code << tab
					<< oltp_read_select_01_array[iRowLoop].p_date << tab
					<< oltp_read_select_01_array[iRowLoop].p_signed << tab
					<< oltp_read_select_01_array[iRowLoop].p_name << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_02

CXact_OLTP_Read_Select_02::CXact_OLTP_Read_Select_02 (void)
{
	m_szName		= "OLTP Read Select 02";
	m_szDescription = "select h_key, h_code, h_date, h_signed, h_address from hundred where h_key between :randbase and :randbaseplus order by h_address";
	m_szSQL			= "select h_key, h_code, h_date, h_signed, h_address from hundred where h_key between ? and ? order by h_address";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+02;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_02::~CXact_OLTP_Read_Select_02 (void)
{
}

BOOL CXact_OLTP_Read_Select_02::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_02::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_02::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd1;
	SQLINTEGER BindParamInd2;
	unsigned long randbase;
	unsigned long randbaseplus;
	struct OLTP_READ_SELECT_02 {
		SQLINTEGER h_key;
		SQLCHAR h_code[15];
		SQLCHAR h_date[35];
		SQLINTEGER h_signed;
		SQLCHAR h_address[85];
	};
	typedef struct OLTP_READ_SELECT_02 OLTP_READ_SELECT_02;
	struct OLTP_READ_SELECT_02_INDICATORS {
		SQLINTEGER h_key;
		SQLINTEGER h_code;
		SQLINTEGER h_date;
		SQLINTEGER h_signed;
		SQLINTEGER h_address;
	};
	typedef struct OLTP_READ_SELECT_02_INDICATORS OLTP_READ_SELECT_02_INDICATORS;
	OLTP_READ_SELECT_02 oltp_read_select_02_array[NUM_ROWS];
	OLTP_READ_SELECT_02_INDICATORS oltp_read_select_02_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd1 = IGNORE;
	BindParamInd2 = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
 	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_02_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd1);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbaseplus, sizeof(randbaseplus), &BindParamInd2);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_02_array[0].h_key, sizeof(oltp_read_select_02_array[0].h_key), &oltp_read_select_02_indicators_array[0].h_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_select_02_array[0].h_code, sizeof(oltp_read_select_02_array[0].h_code), &oltp_read_select_02_indicators_array[0].h_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_CHAR, oltp_read_select_02_array[0].h_date, sizeof(oltp_read_select_02_array[0].h_date), &oltp_read_select_02_indicators_array[0].h_date);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_SLONG, &oltp_read_select_02_array[0].h_signed, sizeof(oltp_read_select_02_array[0].h_signed), &oltp_read_select_02_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_02_array[0].h_address, sizeof(oltp_read_select_02_array[0].h_address), &oltp_read_select_02_indicators_array[0].h_address);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE);
	randbaseplus = randbase + 200;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_02_array[iRowLoop].h_key << tab
					<< oltp_read_select_02_array[iRowLoop].h_code << tab
					<< oltp_read_select_02_array[iRowLoop].h_date << tab
					<< oltp_read_select_02_array[iRowLoop].h_signed << tab
					<< oltp_read_select_02_array[iRowLoop].h_address << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_03

CXact_OLTP_Read_Select_03::CXact_OLTP_Read_Select_03 (void)
{
	m_szName		= "OLTP Read Select 03";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_key = 1001";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_key = 1001";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+03;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_03::~CXact_OLTP_Read_Select_03 (void)
{
}

BOOL CXact_OLTP_Read_Select_03::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_03::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_03::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_03 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_03 OLTP_READ_SELECT_03;
	struct OLTP_READ_SELECT_03_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_03_INDICATORS OLTP_READ_SELECT_03_INDICATORS;
	OLTP_READ_SELECT_03 oltp_read_select_03_array[NUM_ROWS];
	OLTP_READ_SELECT_03_INDICATORS oltp_read_select_03_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_03_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_03_array[0].t_key, sizeof(oltp_read_select_03_array[0].t_key), &oltp_read_select_03_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_03_array[0].t_int, sizeof(oltp_read_select_03_array[0].t_int), &oltp_read_select_03_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_03_array[0].t_signed, sizeof(oltp_read_select_03_array[0].t_signed), &oltp_read_select_03_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_03_array[0].t_double, sizeof(oltp_read_select_03_array[0].t_double), &oltp_read_select_03_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_03_array[0].t_code, sizeof(oltp_read_select_03_array[0].t_code), &oltp_read_select_03_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_03_array[0].t_name, sizeof(oltp_read_select_03_array[0].t_name), &oltp_read_select_03_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_03_array[iRowLoop].t_key << tab
					<< oltp_read_select_03_array[iRowLoop].t_int << tab
					<< oltp_read_select_03_array[iRowLoop].t_signed << tab
					<< oltp_read_select_03_array[iRowLoop].t_double << tab
					<< oltp_read_select_03_array[iRowLoop].t_code << tab
					<< oltp_read_select_03_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_04

CXact_OLTP_Read_Select_04::CXact_OLTP_Read_Select_04 (void)
{
	m_szName		= "OLTP Read Select 04";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_code = 'BENCHMARKS'";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_code = 'BENCHMARKS'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+04;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_04::~CXact_OLTP_Read_Select_04 (void)
{
}

BOOL CXact_OLTP_Read_Select_04::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_04::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_04::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_04 {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLDOUBLE p_double;
		SQLCHAR p_code[15];
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_SELECT_04 OLTP_READ_SELECT_04;
	struct OLTP_READ_SELECT_04_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLINTEGER p_double;
		SQLINTEGER p_code;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_SELECT_04_INDICATORS OLTP_READ_SELECT_04_INDICATORS;
	OLTP_READ_SELECT_04 oltp_read_select_04_array[NUM_ROWS];
	OLTP_READ_SELECT_04_INDICATORS oltp_read_select_04_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_04_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_04_array[0].p_key, sizeof(oltp_read_select_04_array[0].p_key), &oltp_read_select_04_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_04_array[0].p_int, sizeof(oltp_read_select_04_array[0].p_int), &oltp_read_select_04_indicators_array[0].p_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_04_array[0].p_signed, sizeof(oltp_read_select_04_array[0].p_signed), &oltp_read_select_04_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_04_array[0].p_double, sizeof(oltp_read_select_04_array[0].p_double), &oltp_read_select_04_indicators_array[0].p_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_04_array[0].p_code, sizeof(oltp_read_select_04_array[0].p_code), &oltp_read_select_04_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_04_array[0].p_name, sizeof(oltp_read_select_04_array[0].p_name), &oltp_read_select_04_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_04_array[iRowLoop].p_key << tab
					<< oltp_read_select_04_array[iRowLoop].p_int << tab
					<< oltp_read_select_04_array[iRowLoop].p_signed << tab
					<< oltp_read_select_04_array[iRowLoop].p_double << tab
					<< oltp_read_select_04_array[iRowLoop].p_code << tab
					<< oltp_read_select_04_array[iRowLoop].p_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_05

CXact_OLTP_Read_Select_05::CXact_OLTP_Read_Select_05 (void)
{
	m_szName		= "OLTP Read Select 05";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_key <= 100";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_key <= 100";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+05;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_05::~CXact_OLTP_Read_Select_05 (void)
{
}

BOOL CXact_OLTP_Read_Select_05::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_05::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_05::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_05 {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLDOUBLE p_double;
		SQLCHAR p_code[15];
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_SELECT_05 OLTP_READ_SELECT_05;
	struct OLTP_READ_SELECT_05_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLINTEGER p_double;
		SQLINTEGER p_code;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_SELECT_05_INDICATORS OLTP_READ_SELECT_05_INDICATORS;
	OLTP_READ_SELECT_05 oltp_read_select_05_array[NUM_ROWS];
	OLTP_READ_SELECT_05_INDICATORS oltp_read_select_05_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_05_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_05_array[0].p_key, sizeof(oltp_read_select_05_array[0].p_key), &oltp_read_select_05_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_05_array[0].p_int, sizeof(oltp_read_select_05_array[0].p_int), &oltp_read_select_05_indicators_array[0].p_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_05_array[0].p_signed, sizeof(oltp_read_select_05_array[0].p_signed), &oltp_read_select_05_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_05_array[0].p_double, sizeof(oltp_read_select_05_array[0].p_double), &oltp_read_select_05_indicators_array[0].p_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_05_array[0].p_code, sizeof(oltp_read_select_05_array[0].p_code), &oltp_read_select_05_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_05_array[0].p_name, sizeof(oltp_read_select_05_array[0].p_name), &oltp_read_select_05_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_05_array[iRowLoop].p_key << tab
					<< oltp_read_select_05_array[iRowLoop].p_int << tab
					<< oltp_read_select_05_array[iRowLoop].p_signed << tab
					<< oltp_read_select_05_array[iRowLoop].p_double << tab
					<< oltp_read_select_05_array[iRowLoop].p_code << tab
					<< oltp_read_select_05_array[iRowLoop].p_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_06

CXact_OLTP_Read_Select_06::CXact_OLTP_Read_Select_06 (void)
{
	m_szName		= "OLTP Read Select 06";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_int = :randbase";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from updates where p_int = ?";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+06;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_06::~CXact_OLTP_Read_Select_06 (void)
{
}

BOOL CXact_OLTP_Read_Select_06::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_06::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_06::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd;
	unsigned long randbase;
	struct OLTP_READ_SELECT_06 {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLDOUBLE p_double;
		SQLCHAR p_code[15];
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_SELECT_06 OLTP_READ_SELECT_06;
	struct OLTP_READ_SELECT_06_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLINTEGER p_double;
		SQLINTEGER p_code;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_SELECT_06_INDICATORS OLTP_READ_SELECT_06_INDICATORS;
	OLTP_READ_SELECT_06 oltp_read_select_06_array[NUM_ROWS];
	OLTP_READ_SELECT_06_INDICATORS oltp_read_select_06_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_06_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbase, sizeof(randbase), &BindParamInd);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_06_array[0].p_key, sizeof(oltp_read_select_06_array[0].p_key), &oltp_read_select_06_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_06_array[0].p_int, sizeof(oltp_read_select_06_array[0].p_int), &oltp_read_select_06_indicators_array[0].p_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_06_array[0].p_signed, sizeof(oltp_read_select_06_array[0].p_signed), &oltp_read_select_06_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_06_array[0].p_double, sizeof(oltp_read_select_06_array[0].p_double), &oltp_read_select_06_indicators_array[0].p_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_06_array[0].p_code, sizeof(oltp_read_select_06_array[0].p_code), &oltp_read_select_06_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_06_array[0].p_name, sizeof(oltp_read_select_06_array[0].p_name), &oltp_read_select_06_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;
	randbase = (long) m_CRandom.GetRandom(2,RANDBASE);

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_06_array[iRowLoop].p_key << tab
					<< oltp_read_select_06_array[iRowLoop].p_int << tab
					<< oltp_read_select_06_array[iRowLoop].p_signed << tab
					<< oltp_read_select_06_array[iRowLoop].p_double << tab
					<< oltp_read_select_06_array[iRowLoop].p_code << tab
					<< oltp_read_select_06_array[iRowLoop].p_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_07

CXact_OLTP_Read_Select_07::CXact_OLTP_Read_Select_07 (void)
{
	m_szName		= "OLTP Read Select 07";
	m_szDescription = "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_key <= 1000";
	m_szSQL			= "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_key <= 1000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+07;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_07::~CXact_OLTP_Read_Select_07 (void)
{
}

BOOL CXact_OLTP_Read_Select_07::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_07::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_07::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_07 {
		SQLINTEGER u_key;
		SQLINTEGER u_int;
		SQLINTEGER u_signed;
		SQLDOUBLE u_double;
		SQLCHAR u_code[15];
		SQLCHAR u_name[25];
	};
	typedef struct OLTP_READ_SELECT_07 OLTP_READ_SELECT_07;
	struct OLTP_READ_SELECT_07_INDICATORS {
		SQLINTEGER u_key;
		SQLINTEGER u_int;
		SQLINTEGER u_signed;
		SQLINTEGER u_double;
		SQLINTEGER u_code;
		SQLINTEGER u_name;
	};
	typedef struct OLTP_READ_SELECT_07_INDICATORS OLTP_READ_SELECT_07_INDICATORS;
	OLTP_READ_SELECT_07 oltp_read_select_07_array[NUM_ROWS];
	OLTP_READ_SELECT_07_INDICATORS oltp_read_select_07_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_07_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_07_array[0].u_key, sizeof(oltp_read_select_07_array[0].u_key), &oltp_read_select_07_indicators_array[0].u_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_07_array[0].u_int, sizeof(oltp_read_select_07_array[0].u_int), &oltp_read_select_07_indicators_array[0].u_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_07_array[0].u_signed, sizeof(oltp_read_select_07_array[0].u_signed), &oltp_read_select_07_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_07_array[0].u_double, sizeof(oltp_read_select_07_array[0].u_double), &oltp_read_select_07_indicators_array[0].u_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_07_array[0].u_code, sizeof(oltp_read_select_07_array[0].u_code), &oltp_read_select_07_indicators_array[0].u_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_07_array[0].u_name, sizeof(oltp_read_select_07_array[0].u_name), &oltp_read_select_07_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_07_array[iRowLoop].u_key << tab
					<< oltp_read_select_07_array[iRowLoop].u_int << tab
					<< oltp_read_select_07_array[iRowLoop].u_signed << tab
					<< oltp_read_select_07_array[iRowLoop].u_double << tab
					<< oltp_read_select_07_array[iRowLoop].u_code << tab
					<< oltp_read_select_07_array[iRowLoop].u_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_08

CXact_OLTP_Read_Select_08::CXact_OLTP_Read_Select_08 (void)
{
	m_szName		= "OLTP Read Select 08";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and (t_key between :randbillion and :randbillionplus)";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and (t_key between ? and ?)";
	m_nXactType		= randomTRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+8;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_08::~CXact_OLTP_Read_Select_08 (void)
{
}

BOOL CXact_OLTP_Read_Select_08::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_08::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_08::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	SQLINTEGER BindParamInd1;
	SQLINTEGER BindParamInd2;
	unsigned long randbillion;
	unsigned long randbillionplus;
	struct OLTP_READ_SELECT_08 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_08 OLTP_READ_SELECT_08;
	struct OLTP_READ_SELECT_08_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_08_INDICATORS OLTP_READ_SELECT_08_INDICATORS;
	OLTP_READ_SELECT_08 oltp_read_select_08_array[NUM_ROWS];
	OLTP_READ_SELECT_08_INDICATORS oltp_read_select_08_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	BindParamInd1 = IGNORE;
	BindParamInd2 = IGNORE;
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;

	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_08_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind input variables
	ReturnCode = SQLBindParameter (hstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbillion, sizeof(randbillion), &BindParamInd1);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindParameter (hstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, IGNORE, IGNORE, &randbillionplus, sizeof(randbillionplus), &BindParamInd2);
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_08_array[0].t_key, sizeof(oltp_read_select_08_array[0].t_key), &oltp_read_select_08_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_08_array[0].t_int, sizeof(oltp_read_select_08_array[0].t_int), &oltp_read_select_08_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_08_array[0].t_signed, sizeof(oltp_read_select_08_array[0].t_signed), &oltp_read_select_08_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_08_array[0].t_double, sizeof(oltp_read_select_08_array[0].t_double), &oltp_read_select_08_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_08_array[0].t_code, sizeof(oltp_read_select_08_array[0].t_code), &oltp_read_select_08_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_08_array[0].t_name, sizeof(oltp_read_select_08_array[0].t_name), &oltp_read_select_08_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// initialize variables
	randbillion = (long) m_CRandom.GetRandom(2,1000000000);
	randbillionplus = randbillion + 10000;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_08_array[iRowLoop].t_key << tab
					<< oltp_read_select_08_array[iRowLoop].t_int << tab
					<< oltp_read_select_08_array[iRowLoop].t_signed << tab
					<< oltp_read_select_08_array[iRowLoop].t_double << tab
					<< oltp_read_select_08_array[iRowLoop].t_code << tab
					<< oltp_read_select_08_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_09

CXact_OLTP_Read_Select_09::CXact_OLTP_Read_Select_09 (void)
{
	m_szName		= "OLTP Read Select 09";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_signed <= -500000000";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_signed <= -500000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+9;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_09::~CXact_OLTP_Read_Select_09 (void)
{
}

BOOL CXact_OLTP_Read_Select_09::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_09::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_09::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_09 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_09 OLTP_READ_SELECT_09;
	struct OLTP_READ_SELECT_09_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_09_INDICATORS OLTP_READ_SELECT_09_INDICATORS;
	OLTP_READ_SELECT_09 oltp_read_select_09_array[NUM_ROWS];
	OLTP_READ_SELECT_09_INDICATORS oltp_read_select_09_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_09_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_09_array[0].t_key, sizeof(oltp_read_select_09_array[0].t_key), &oltp_read_select_09_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_09_array[0].t_int, sizeof(oltp_read_select_09_array[0].t_int), &oltp_read_select_09_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_09_array[0].t_signed, sizeof(oltp_read_select_09_array[0].t_signed), &oltp_read_select_09_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_09_array[0].t_double, sizeof(oltp_read_select_09_array[0].t_double), &oltp_read_select_09_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_09_array[0].t_code, sizeof(oltp_read_select_09_array[0].t_code), &oltp_read_select_09_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_09_array[0].t_name, sizeof(oltp_read_select_09_array[0].t_name), &oltp_read_select_09_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_09_array[iRowLoop].t_key << tab
					<< oltp_read_select_09_array[iRowLoop].t_int << tab
					<< oltp_read_select_09_array[iRowLoop].t_signed << tab
					<< oltp_read_select_09_array[iRowLoop].t_double << tab
					<< oltp_read_select_09_array[iRowLoop].t_code << tab
					<< oltp_read_select_09_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_10

CXact_OLTP_Read_Select_10::CXact_OLTP_Read_Select_10 (void)
{
	m_szName		= "OLTP Read Select 10";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -475000000 order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -475000000 order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+10;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_10::~CXact_OLTP_Read_Select_10 (void)
{
}

BOOL CXact_OLTP_Read_Select_10::PreBenchmark (void)
{
	return TRUE;
}
		
BOOL CXact_OLTP_Read_Select_10::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_10::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_10 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_10 OLTP_READ_SELECT_10;
	struct OLTP_READ_SELECT_10_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_10_INDICATORS OLTP_READ_SELECT_10_INDICATORS;
	OLTP_READ_SELECT_10 oltp_read_select_10_array[NUM_ROWS];
	OLTP_READ_SELECT_10_INDICATORS oltp_read_select_10_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_10_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_10_array[0].t_key, sizeof(oltp_read_select_10_array[0].t_key), &oltp_read_select_10_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_10_array[0].t_int, sizeof(oltp_read_select_10_array[0].t_int), &oltp_read_select_10_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_10_array[0].t_signed, sizeof(oltp_read_select_10_array[0].t_signed), &oltp_read_select_10_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_10_array[0].t_double, sizeof(oltp_read_select_10_array[0].t_double), &oltp_read_select_10_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_10_array[0].t_code, sizeof(oltp_read_select_10_array[0].t_code), &oltp_read_select_10_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_10_array[0].t_name, sizeof(oltp_read_select_10_array[0].t_name), &oltp_read_select_10_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_10_array[iRowLoop].t_key << tab
					<< oltp_read_select_10_array[iRowLoop].t_int << tab
					<< oltp_read_select_10_array[iRowLoop].t_signed << tab
					<< oltp_read_select_10_array[iRowLoop].t_double << tab
					<< oltp_read_select_10_array[iRowLoop].t_code << tab
					<< oltp_read_select_10_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_11

CXact_OLTP_Read_Select_11::CXact_OLTP_Read_Select_11 (void)
{
	m_szName		= "OLTP Read Select 11";
	m_szDescription = "select p_key, p_int, p_signed, p_double, p_code, p_name from twomill where p_key = 1";
	m_szSQL			= "select p_key, p_int, p_signed, p_double, p_code, p_name from twomill where p_key = 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+11;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_11::~CXact_OLTP_Read_Select_11 (void)
{
}

BOOL CXact_OLTP_Read_Select_11::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_11::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_11::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_11 {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLDOUBLE p_double;
		SQLCHAR p_code[15];
		SQLCHAR p_name[25];
	};
	typedef struct OLTP_READ_SELECT_11 OLTP_READ_SELECT_11;
	struct OLTP_READ_SELECT_11_INDICATORS {
		SQLINTEGER p_key;
		SQLINTEGER p_int;
		SQLINTEGER p_signed;
		SQLINTEGER p_double;
		SQLINTEGER p_code;
		SQLINTEGER p_name;
	};
	typedef struct OLTP_READ_SELECT_11_INDICATORS OLTP_READ_SELECT_11_INDICATORS;
	OLTP_READ_SELECT_11 oltp_read_select_11_array[NUM_ROWS];
	OLTP_READ_SELECT_11_INDICATORS oltp_read_select_11_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_11_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_11_array[0].p_key, sizeof(oltp_read_select_11_array[0].p_key), &oltp_read_select_11_indicators_array[0].p_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_11_array[0].p_int, sizeof(oltp_read_select_11_array[0].p_int), &oltp_read_select_11_indicators_array[0].p_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_11_array[0].p_signed, sizeof(oltp_read_select_11_array[0].p_signed), &oltp_read_select_11_indicators_array[0].p_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_11_array[0].p_double, sizeof(oltp_read_select_11_array[0].p_double), &oltp_read_select_11_indicators_array[0].p_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_11_array[0].p_code, sizeof(oltp_read_select_11_array[0].p_code), &oltp_read_select_11_indicators_array[0].p_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_11_array[0].p_name, sizeof(oltp_read_select_11_array[0].p_name), &oltp_read_select_11_indicators_array[0].p_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_11_array[iRowLoop].p_key << tab
					<< oltp_read_select_11_array[iRowLoop].p_int << tab
					<< oltp_read_select_11_array[iRowLoop].p_signed << tab
					<< oltp_read_select_11_array[iRowLoop].p_double << tab
					<< oltp_read_select_11_array[iRowLoop].p_code << tab
					<< oltp_read_select_11_array[iRowLoop].p_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_12

CXact_OLTP_Read_Select_12::CXact_OLTP_Read_Select_12 (void)
{
	m_szName		= "OLTP Read Select 12";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name like 'THE+%' and t_signed > 499000000 order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_name like 'THE+%' and t_signed > 499000000 order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+12;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_12::~CXact_OLTP_Read_Select_12 (void)
{
}

BOOL CXact_OLTP_Read_Select_12::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_12::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_12::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_12 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_12 OLTP_READ_SELECT_12;
	struct OLTP_READ_SELECT_12_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_12_INDICATORS OLTP_READ_SELECT_12_INDICATORS;
	OLTP_READ_SELECT_12 oltp_read_select_12_array[NUM_ROWS];
	OLTP_READ_SELECT_12_INDICATORS oltp_read_select_12_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_12_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_12_array[0].t_key, sizeof(oltp_read_select_12_array[0].t_key), &oltp_read_select_12_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_12_array[0].t_int, sizeof(oltp_read_select_12_array[0].t_int), &oltp_read_select_12_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_12_array[0].t_signed, sizeof(oltp_read_select_12_array[0].t_signed), &oltp_read_select_12_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_12_array[0].t_double, sizeof(oltp_read_select_12_array[0].t_double), &oltp_read_select_12_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_12_array[0].t_code, sizeof(oltp_read_select_12_array[0].t_code), &oltp_read_select_12_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_12_array[0].t_name, sizeof(oltp_read_select_12_array[0].t_name), &oltp_read_select_12_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_12_array[iRowLoop].t_key << tab
					<< oltp_read_select_12_array[iRowLoop].t_int << tab
					<< oltp_read_select_12_array[iRowLoop].t_signed << tab
					<< oltp_read_select_12_array[iRowLoop].t_double << tab
					<< oltp_read_select_12_array[iRowLoop].t_code << tab
					<< oltp_read_select_12_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_12_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_13

CXact_OLTP_Read_Select_13::CXact_OLTP_Read_Select_13 (void)
{
	m_szName		= "OLTP Read Select 13";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date > {d '1999-12-15'} order by t_date";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date > {d '1999-12-15'} order by t_date";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+13;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_13::~CXact_OLTP_Read_Select_13 (void)
{
}

BOOL CXact_OLTP_Read_Select_13::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_13::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_13::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_13 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_13 OLTP_READ_SELECT_13;
	struct OLTP_READ_SELECT_13_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_13_INDICATORS OLTP_READ_SELECT_13_INDICATORS;
	OLTP_READ_SELECT_13 oltp_read_select_13_array[NUM_ROWS];
	OLTP_READ_SELECT_13_INDICATORS oltp_read_select_13_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_13_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_13_array[0].t_key, sizeof(oltp_read_select_13_array[0].t_key), &oltp_read_select_13_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_13_array[0].t_int, sizeof(oltp_read_select_13_array[0].t_int), &oltp_read_select_13_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_13_array[0].t_signed, sizeof(oltp_read_select_13_array[0].t_signed), &oltp_read_select_13_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_13_array[0].t_double, sizeof(oltp_read_select_13_array[0].t_double), &oltp_read_select_13_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_13_array[0].t_code, sizeof(oltp_read_select_13_array[0].t_code), &oltp_read_select_13_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_13_array[0].t_name, sizeof(oltp_read_select_13_array[0].t_name), &oltp_read_select_13_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_13_array[iRowLoop].t_key << tab
					<< oltp_read_select_13_array[iRowLoop].t_int << tab
					<< oltp_read_select_13_array[iRowLoop].t_signed << tab
					<< oltp_read_select_13_array[iRowLoop].t_double << tab
					<< oltp_read_select_13_array[iRowLoop].t_code << tab
					<< oltp_read_select_13_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_13_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_14

CXact_OLTP_Read_Select_14::CXact_OLTP_Read_Select_14 (void)
{
	m_szName		= "OLTP Read Select 14";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date between {d '1942-01-10'} and {d '1942-01-21'} order by t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenpct where t_date between {d '1942-01-10'} and {d '1942-01-21'} order by t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+14;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_14::~CXact_OLTP_Read_Select_14 (void)
{
}

BOOL CXact_OLTP_Read_Select_14::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_14::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_14::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_14 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_14 OLTP_READ_SELECT_14;
	struct OLTP_READ_SELECT_14_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_14_INDICATORS OLTP_READ_SELECT_14_INDICATORS;
	OLTP_READ_SELECT_14 oltp_read_select_14_array[NUM_ROWS];
	OLTP_READ_SELECT_14_INDICATORS oltp_read_select_14_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_14_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_14_array[0].t_key, sizeof(oltp_read_select_14_array[0].t_key), &oltp_read_select_14_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_14_array[0].t_int, sizeof(oltp_read_select_14_array[0].t_int), &oltp_read_select_14_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_14_array[0].t_signed, sizeof(oltp_read_select_14_array[0].t_signed), &oltp_read_select_14_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_14_array[0].t_double, sizeof(oltp_read_select_14_array[0].t_double), &oltp_read_select_14_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_14_array[0].t_code, sizeof(oltp_read_select_14_array[0].t_code), &oltp_read_select_14_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_14_array[0].t_name, sizeof(oltp_read_select_14_array[0].t_name), &oltp_read_select_14_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_14_array[iRowLoop].t_key << tab
					<< oltp_read_select_14_array[iRowLoop].t_int << tab
					<< oltp_read_select_14_array[iRowLoop].t_signed << tab
					<< oltp_read_select_14_array[iRowLoop].t_double << tab
					<< oltp_read_select_14_array[iRowLoop].t_code << tab
					<< oltp_read_select_14_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_14_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_15

CXact_OLTP_Read_Select_15::CXact_OLTP_Read_Select_15 (void)
{
	m_szName		= "OLTP Read Select 15";
	m_szDescription = "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_name = 'xxxxxxxxxx'";
	m_szSQL			= "select u_key, u_int, u_signed, u_double, u_code, u_name from uniques where u_name = 'xxxxxxxxxx'";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+15;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_15::~CXact_OLTP_Read_Select_15 (void)
{
}

BOOL CXact_OLTP_Read_Select_15::PreBenchmark (void)
{
	return TRUE;
}
	
BOOL CXact_OLTP_Read_Select_15::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_15::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_15 {
		SQLINTEGER u_key;
		SQLINTEGER u_int;
		SQLINTEGER u_signed;
		SQLDOUBLE u_double;
		SQLCHAR u_code[15];
		SQLCHAR u_name[25];
	};
	typedef struct OLTP_READ_SELECT_15 OLTP_READ_SELECT_15;
	struct OLTP_READ_SELECT_15_INDICATORS {
		SQLINTEGER u_key;
		SQLINTEGER u_int;
		SQLINTEGER u_signed;
		SQLINTEGER u_double;
		SQLINTEGER u_code;
		SQLINTEGER u_name;
	};
	typedef struct OLTP_READ_SELECT_15_INDICATORS OLTP_READ_SELECT_15_INDICATORS;
	OLTP_READ_SELECT_15 oltp_read_select_15_array[NUM_ROWS];
	OLTP_READ_SELECT_15_INDICATORS oltp_read_select_15_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_15_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_15_array[0].u_key, sizeof(oltp_read_select_15_array[0].u_key), &oltp_read_select_15_indicators_array[0].u_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_15_array[0].u_int, sizeof(oltp_read_select_15_array[0].u_int), &oltp_read_select_15_indicators_array[0].u_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_15_array[0].u_signed, sizeof(oltp_read_select_15_array[0].u_signed), &oltp_read_select_15_indicators_array[0].u_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_15_array[0].u_double, sizeof(oltp_read_select_15_array[0].u_double), &oltp_read_select_15_indicators_array[0].u_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_15_array[0].u_code, sizeof(oltp_read_select_15_array[0].u_code), &oltp_read_select_15_indicators_array[0].u_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_15_array[0].u_name, sizeof(oltp_read_select_15_array[0].u_name), &oltp_read_select_15_indicators_array[0].u_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_15_array[iRowLoop].u_key << tab
					<< oltp_read_select_15_array[iRowLoop].u_int << tab
					<< oltp_read_select_15_array[iRowLoop].u_signed << tab
					<< oltp_read_select_15_array[iRowLoop].u_double << tab
					<< oltp_read_select_15_array[iRowLoop].u_code << tab
					<< oltp_read_select_15_array[iRowLoop].u_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_15_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_16

CXact_OLTP_Read_Select_16::CXact_OLTP_Read_Select_16 (void)
{
	m_szName		= "OLTP Read Select 16";
	m_szDescription = "select distinct h_signed, h_address from hunthou where h_signed = 100 order by h_address";
	m_szSQL			= "select distinct h_signed, h_address from hunthou where h_signed = 100 order by h_address";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+16;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_16::~CXact_OLTP_Read_Select_16 (void)
{
}

BOOL CXact_OLTP_Read_Select_16::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_16::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_16::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_16 {
		SQLINTEGER h_signed;
		SQLCHAR h_address[85];
	};
	typedef struct OLTP_READ_SELECT_16 OLTP_READ_SELECT_16;
	struct OLTP_READ_SELECT_16_INDICATORS {
		SQLINTEGER h_signed;
		SQLINTEGER h_address;
	};
	typedef struct OLTP_READ_SELECT_16_INDICATORS OLTP_READ_SELECT_16_INDICATORS;
	OLTP_READ_SELECT_16 oltp_read_select_16_array[NUM_ROWS];
	OLTP_READ_SELECT_16_INDICATORS oltp_read_select_16_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_16_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);

	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_16_array[0].h_signed, sizeof(oltp_read_select_16_array[0].h_signed), &oltp_read_select_16_indicators_array[0].h_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_CHAR, oltp_read_select_16_array[0].h_address, sizeof(oltp_read_select_16_array[0].h_address), &oltp_read_select_16_indicators_array[0].h_address);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_16_array[iRowLoop].h_signed << tab
					<< oltp_read_select_16_array[iRowLoop].h_address << endl;
			}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_16_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_17

CXact_OLTP_Read_Select_17::CXact_OLTP_Read_Select_17 (void)
{
	m_szName		= "OLTP Read Select 17";
	m_szDescription = "select distinct t_decim from tenthou order by t_decim";
	m_szSQL			= "select distinct t_decim from tenthou order by t_decim";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+17;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_17::~CXact_OLTP_Read_Select_17 (void)
{
}

BOOL CXact_OLTP_Read_Select_17::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_17::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_17::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_17 {
		SQLCHAR t_decim[20];
	};
	typedef struct OLTP_READ_SELECT_17 OLTP_READ_SELECT_17;
	struct OLTP_READ_SELECT_17_INDICATORS {
		SQLINTEGER t_decim;
	};
	typedef struct OLTP_READ_SELECT_17_INDICATORS OLTP_READ_SELECT_17_INDICATORS;
	OLTP_READ_SELECT_17 oltp_read_select_17_array[NUM_ROWS];
	OLTP_READ_SELECT_17_INDICATORS oltp_read_select_17_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_17_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_CHAR, oltp_read_select_17_array[0].t_decim, sizeof(oltp_read_select_17_array[0].t_decim), &oltp_read_select_17_indicators_array[0].t_decim);
	// will only get error message for last SQLBindCol call
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_17_array[iRowLoop].t_decim << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_17_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}

// ================================================================================

// CXact_OLTP_Read_Select_18

CXact_OLTP_Read_Select_18::CXact_OLTP_Read_Select_18 (void)
{
	m_szName		= "OLTP Read Select 18";
	m_szDescription = "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -490000000 order by t_name, t_key";
	m_szSQL			= "select t_key, t_int, t_signed, t_double, t_code, t_name from tenthou where t_signed <= -490000000 order by t_name, t_key";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_OLTP_READ_SELECT+18;
	m_nGID			= OLTPReadSelect;
}

CXact_OLTP_Read_Select_18::~CXact_OLTP_Read_Select_18 (void)
{
}

BOOL CXact_OLTP_Read_Select_18::PreBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_18::PostBenchmark (void)
{
	return TRUE;
}

BOOL CXact_OLTP_Read_Select_18::Execute (void)
{

	// declare variables
	CSSOdbcDriver *pSQLDatabaseServer;
	SQLHSTMT hstmt;
	int iRowLoop;
	int ReturnCode;
	struct OLTP_READ_SELECT_18 {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLDOUBLE t_double;
		SQLCHAR t_code[15];
		SQLCHAR t_name[25];
	};
	typedef struct OLTP_READ_SELECT_18 OLTP_READ_SELECT_18;
	struct OLTP_READ_SELECT_18_INDICATORS {
		SQLINTEGER t_key;
		SQLINTEGER t_int;
		SQLINTEGER t_signed;
		SQLINTEGER t_double;
		SQLINTEGER t_code;
		SQLINTEGER t_name;
	};
	typedef struct OLTP_READ_SELECT_18_INDICATORS OLTP_READ_SELECT_18_INDICATORS;
	OLTP_READ_SELECT_18 oltp_read_select_18_array[NUM_ROWS];
	OLTP_READ_SELECT_18_INDICATORS oltp_read_select_18_indicators_array[NUM_ROWS];
	SQLUSMALLINT row_status_array[NUM_ROWS];

	// initialize variables
	pSQLDatabaseServer = (CSSOdbcDriver*) m_pCSQLObject;
	
	// allocate a statement handle
	ReturnCode = SQLAllocHandle (SQL_HANDLE_STMT, pSQLDatabaseServer->GetDatabaseHandle(), &hstmt);
	CHECK_FOR_ERROR (hstmt);

	// set statement attributes
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_BIND_TYPE, (PTR)sizeof(oltp_read_select_18_array[0]), SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_ARRAY_SIZE, (PTR)NUM_ROWS, SQL_IS_INTEGER);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLSetStmtAttr (hstmt, SQL_ATTR_ROW_STATUS_PTR, row_status_array, SQL_IS_POINTER);
	CHECK_FOR_ERROR (hstmt);
	
	// prepare the statement	
	ReturnCode = SQLPrepare (hstmt, (UCHAR *)m_szSQL.GetBuffer(0), SQL_NTS);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR (hstmt);
	
	// bind output variables
	ReturnCode = SQLBindCol (hstmt, 1, SQL_C_SLONG, &oltp_read_select_18_array[0].t_key, sizeof(oltp_read_select_18_array[0].t_key), &oltp_read_select_18_indicators_array[0].t_key);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 2, SQL_C_SLONG, &oltp_read_select_18_array[0].t_int, sizeof(oltp_read_select_18_array[0].t_int), &oltp_read_select_18_indicators_array[0].t_int);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 3, SQL_C_SLONG, &oltp_read_select_18_array[0].t_signed, sizeof(oltp_read_select_18_array[0].t_signed), &oltp_read_select_18_indicators_array[0].t_signed);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 4, SQL_C_DOUBLE, &oltp_read_select_18_array[0].t_double, sizeof(oltp_read_select_18_array[0].t_double), &oltp_read_select_18_indicators_array[0].t_double);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 5, SQL_C_CHAR, oltp_read_select_18_array[0].t_code, sizeof(oltp_read_select_18_array[0].t_code), &oltp_read_select_18_indicators_array[0].t_code);
	CHECK_FOR_ERROR (hstmt);
	ReturnCode = SQLBindCol (hstmt, 6, SQL_C_CHAR, oltp_read_select_18_array[0].t_name, sizeof(oltp_read_select_18_array[0].t_name), &oltp_read_select_18_indicators_array[0].t_name);
	CHECK_FOR_ERROR (hstmt);

	// ==========
	
	// initialize variables
	m_nUnits = 0;

	// start timer
	m_CTimer.SetStartTime();

	// execute the statement
	ReturnCode = SQLExecute (hstmt);
	CHECK_FOR_ERROR_EXECUTE (hstmt);

	// fetch loop
	while (TRUE) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nUnits, m_nBytes);
				ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
				CHECK_FOR_ERROR (hstmt);
				return FALSE;
		}

		// fetch the data
		ReturnCode = SQLFetchScroll (hstmt, SQL_FETCH_NEXT, IGNORE);
		CHECK_FOR_ERROR_FETCH (hstmt);

		// if no more data, exit loop
		if (ReturnCode == SQL_NO_DATA)
			break;

		// otherwise, count number of rows returned
		for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
			m_nUnits++;
		}

		// if this is the first time through, record response time
		if (m_nUnits <= NUM_ROWS)
			m_CTimer.SetResponseTime();

		// output data to log if requested
		if (OutputResults())
			for (iRowLoop = 0; row_status_array[iRowLoop] != SQL_ROW_NOROW && iRowLoop < NUM_ROWS; iRowLoop++) {
				GetResultsFile() 
					<< oltp_read_select_18_array[iRowLoop].t_key << tab
					<< oltp_read_select_18_array[iRowLoop].t_int << tab
					<< oltp_read_select_18_array[iRowLoop].t_signed << tab
					<< oltp_read_select_18_array[iRowLoop].t_double << tab
					<< oltp_read_select_18_array[iRowLoop].t_code << tab
					<< oltp_read_select_18_array[iRowLoop].t_name << endl;
		}

	}

	// update statistics
	m_nBytes = m_nUnits * sizeof(oltp_read_select_18_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nUnits, m_nBytes);

	// free handle
	ReturnCode = SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
	CHECK_FOR_ERROR (hstmt);

	// return
	return TRUE;

}
